/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.nooj4nlp.controller.TextCorpusDialog.TextNewActionListener;
import net.nooj4nlp.controller.TextEditorShell.ImportTextActionListener;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.SystemEnvironment;
import net.nooj4nlp.gui.actions.shells.construct.NewTextCorpusActionListener;
import net.nooj4nlp.gui.dialogs.TextCorpusDialogDelimiterActionListener;
import net.nooj4nlp.gui.dialogs.TextCorpusDialogEncodingActionListener;
import net.nooj4nlp.gui.main.Launcher;

public class TextCorpusDialog
extends JDialog {
    private static final long serialVersionUID = 8534560794082502310L;
    private final JPanel contentPanel = new JPanel();
    private JList listLanguages;
    private JRadioButton rdbtnAsciiUnicode;
    private static JRadioButton rdbtnOtherRawText;
    private JRadioButton rdbtnRichTextFormat;
    private JRadioButton rdbtnHtmlPage;
    private JRadioButton rdbtnPdfDocument;
    private JRadioButton rdbtndoc;
    private static JList listFFormats;
    private static JRadioButton rdbtnNoDelimiterwhole;
    private static JRadioButton rdbtnLineDelimiter;
    private static JRadioButton rdbtnPerlRegExpr;
    private static JRadioButton rdbtnXmlTextNodes;
    private static JComboBox comboPerl;
    private static JComboBox comboXml;

    public TextCorpusDialog(boolean corpus, boolean textImport, JInternalFrame frame, File fileToBeImported) {
        this.setBounds(100, 100, 494, 443);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        JPanel pnlLang = new JPanel();
        pnlLang.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "(1) Select:", 4, 2, null, new Color(0, 0, 0)));
        pnlLang.setBounds(10, 11, 119, 240);
        this.contentPanel.add(pnlLang);
        pnlLang.setLayout(null);
        this.listLanguages = new JList<String>(Language.getAllLanguages());
        this.listLanguages.setSelectedValue(Launcher.preferences.deflanguage, false);
        this.listLanguages.setSelectionMode(0);
        this.listLanguages.setBorder(new BevelBorder(1, null, null, null, null));
        JScrollPane scrollLanguages = new JScrollPane(this.listLanguages);
        scrollLanguages.setBounds(10, 24, 99, 205);
        pnlLang.add(scrollLanguages);
        JPanel pnlFileFormat = new JPanel();
        pnlFileFormat.setBorder(new TitledBorder(null, "(2) Enter file format:", 4, 2, null, null));
        pnlFileFormat.setBounds(139, 11, 352, 240);
        this.contentPanel.add(pnlFileFormat);
        pnlFileFormat.setLayout(null);
        ButtonGroup grpTextFormat = new ButtonGroup();
        this.rdbtnAsciiUnicode = new JRadioButton("<html>ASCII or Byte-Marked Unicode (UTF-8, UTF-16B or UTF-16L)</html>");
        this.rdbtnAsciiUnicode.setBounds(6, 18, 307, 37);
        pnlFileFormat.add(this.rdbtnAsciiUnicode);
        grpTextFormat.add(this.rdbtnAsciiUnicode);
        this.rdbtnAsciiUnicode.setSelected(true);
        this.rdbtnAsciiUnicode.addActionListener(new TextCorpusDialogEncodingActionListener());
        int n = SystemEnvironment.encodings.length;
        rdbtnOtherRawText = new JRadioButton("Other raw text formats(" + n + ")");
        rdbtnOtherRawText.setBounds(6, 58, 307, 23);
        pnlFileFormat.add(rdbtnOtherRawText);
        grpTextFormat.add(rdbtnOtherRawText);
        rdbtnOtherRawText.addActionListener(new TextCorpusDialogEncodingActionListener());
        DefaultListModel<String> model = new DefaultListModel<String>();
        listFFormats = new JList(model);
        listFFormats.setSelectionMode(0);
        listFFormats.setBorder(new BevelBorder(1, null, null, null, null));
        JScrollPane scrollFileFormats = new JScrollPane(listFFormats);
        scrollFileFormats.setHorizontalScrollBarPolicy(31);
        scrollFileFormats.setBounds(6, 88, 161, 141);
        pnlFileFormat.add(scrollFileFormats);
        for (int i = 0; i < n; ++i) {
            String e = SystemEnvironment.encodings[i];
            Charset c = Charset.forName(e);
            e = e + c.aliases().toString();
            model.add(i, e);
        }
        listFFormats.setEnabled(false);
        scrollFileFormats.setEnabled(false);
        this.rdbtnRichTextFormat = new JRadioButton("Rich Text Format");
        this.rdbtnRichTextFormat.setBounds(210, 80, 146, 23);
        pnlFileFormat.add(this.rdbtnRichTextFormat);
        grpTextFormat.add(this.rdbtnRichTextFormat);
        this.rdbtnRichTextFormat.addActionListener(new TextCorpusDialogEncodingActionListener());
        this.rdbtnHtmlPage = new JRadioButton("HTML page");
        this.rdbtnHtmlPage.setBounds(210, 106, 119, 23);
        pnlFileFormat.add(this.rdbtnHtmlPage);
        grpTextFormat.add(this.rdbtnHtmlPage);
        this.rdbtnHtmlPage.addActionListener(new TextCorpusDialogEncodingActionListener());
        this.rdbtnPdfDocument = new JRadioButton("PDF document");
        this.rdbtnPdfDocument.setBounds(210, 132, 125, 23);
        pnlFileFormat.add(this.rdbtnPdfDocument);
        grpTextFormat.add(this.rdbtnPdfDocument);
        this.rdbtnPdfDocument.addActionListener(new TextCorpusDialogEncodingActionListener());
        this.rdbtndoc = new JRadioButton(".doc");
        this.rdbtndoc.setBounds(210, 158, 119, 23);
        pnlFileFormat.add(this.rdbtndoc);
        grpTextFormat.add(this.rdbtndoc);
        this.rdbtndoc.addActionListener(new TextCorpusDialogEncodingActionListener());
        JPanel pnlDelimiter = new JPanel();
        pnlDelimiter.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "(3) Enter Text Unit Delimiter:", 4, 2, null, new Color(0, 0, 0)));
        pnlDelimiter.setBounds(10, 262, 388, 137);
        this.contentPanel.add(pnlDelimiter);
        pnlDelimiter.setLayout(null);
        ButtonGroup grpDelimiter = new ButtonGroup();
        rdbtnNoDelimiterwhole = new JRadioButton("No Delimiter (whole text is processed as one unit)");
        rdbtnNoDelimiterwhole.setBounds(6, 20, 350, 23);
        pnlDelimiter.add(rdbtnNoDelimiterwhole);
        grpDelimiter.add(rdbtnNoDelimiterwhole);
        if (Launcher.getCorpusTextRadioButtonSelectionMemory() == 1) {
            rdbtnNoDelimiterwhole.setSelected(true);
        }
        rdbtnNoDelimiterwhole.addActionListener(new TextCorpusDialogDelimiterActionListener());
        rdbtnLineDelimiter = new JRadioButton("Text Units are lines/paragraphs (\"\\n\")");
        rdbtnLineDelimiter.setBounds(6, 46, 270, 23);
        rdbtnLineDelimiter.setActionCommand("EOL");
        pnlDelimiter.add(rdbtnLineDelimiter);
        grpDelimiter.add(rdbtnLineDelimiter);
        if (Launcher.getCorpusTextRadioButtonSelectionMemory() == 2) {
            rdbtnLineDelimiter.setSelected(true);
        }
        rdbtnLineDelimiter.addActionListener(new TextCorpusDialogDelimiterActionListener());
        comboPerl = new JComboBox<Object>(Launcher.getRegexMemoryList().toArray());
        comboPerl.setEditable(true);
        comboPerl.setEnabled(false);
        comboPerl.setPrototypeDisplayValue("XXX");
        comboPerl.setBounds(138, 73, 243, 23);
        comboPerl.setSelectedIndex(-1);
        pnlDelimiter.add(comboPerl);
        comboXml = new JComboBox<Object>(Launcher.getXmlMemoryList().toArray());
        comboXml.setEditable(true);
        comboXml.setPrototypeDisplayValue("XXX");
        comboXml.setEnabled(false);
        comboXml.setBounds(138, 99, 243, 22);
        comboXml.setSelectedIndex(-1);
        pnlDelimiter.add(comboXml);
        rdbtnPerlRegExpr = new JRadioButton("PERL Reg. Exp.:");
        rdbtnPerlRegExpr.setBounds(6, 72, 130, 23);
        rdbtnPerlRegExpr.setActionCommand("Perl");
        pnlDelimiter.add(rdbtnPerlRegExpr);
        grpDelimiter.add(rdbtnPerlRegExpr);
        if (Launcher.getCorpusTextRadioButtonSelectionMemory() == 3) {
            rdbtnPerlRegExpr.setSelected(true);
            comboPerl.setEnabled(true);
            comboPerl.setSelectedIndex(Launcher.getRegexMemoryIndex());
        }
        rdbtnPerlRegExpr.addActionListener(new TextCorpusDialogDelimiterActionListener());
        rdbtnXmlTextNodes = new JRadioButton("XML Text Nodes:");
        rdbtnXmlTextNodes.setBounds(6, 98, 139, 23);
        rdbtnXmlTextNodes.setActionCommand("XML");
        pnlDelimiter.add(rdbtnXmlTextNodes);
        grpDelimiter.add(rdbtnXmlTextNodes);
        if (Launcher.getCorpusTextRadioButtonSelectionMemory() == 4) {
            rdbtnXmlTextNodes.setSelected(true);
            comboXml.setEnabled(true);
            comboXml.setSelectedIndex(Launcher.getXmlMemoryIndex());
        }
        rdbtnXmlTextNodes.addActionListener(new TextCorpusDialogDelimiterActionListener());
        JButton okButton = new JButton("OK");
        okButton.setBounds(398, 361, 64, 25);
        this.contentPanel.add(okButton);
        okButton.setActionCommand("OK");
        this.getRootPane().setDefaultButton(okButton);
        if (corpus) {
            this.setTitle(NewTextCorpusActionListener.getChosenFileName());
            ImportTextActionListener actionListener = new ImportTextActionListener(this.listLanguages, this, true, fileToBeImported);
            okButton.addActionListener(actionListener);
        } else if (textImport) {
            this.setTitle(NewTextCorpusActionListener.getChosenFileName());
            ImportTextActionListener actionListener = new ImportTextActionListener(this.listLanguages, this, false, fileToBeImported);
            okButton.addActionListener(actionListener);
        } else {
            this.disableAllButDefaultEncoding();
            okButton.addActionListener(new TextNewActionListener(this));
        }
    }

    private void disableAllButDefaultEncoding() {
        this.rdbtnAsciiUnicode.setEnabled(true);
        this.rdbtnAsciiUnicode.setSelected(true);
        rdbtnOtherRawText.setEnabled(false);
        this.rdbtnPdfDocument.setEnabled(false);
        listFFormats.setEnabled(false);
        this.rdbtnRichTextFormat.setEnabled(false);
        this.rdbtnHtmlPage.setEnabled(false);
        this.rdbtndoc.setEnabled(false);
    }

    public JList getListLanguages() {
        return this.listLanguages;
    }

    public JRadioButton getRdbtnAsciiUnicode() {
        return this.rdbtnAsciiUnicode;
    }

    public static JRadioButton getRdbtnOtherRawText() {
        return rdbtnOtherRawText;
    }

    public static JRadioButton getRdbtnNoDelimiterwhole() {
        return rdbtnNoDelimiterwhole;
    }

    public static JRadioButton getRdbtnLineDelimiter() {
        return rdbtnLineDelimiter;
    }

    public static JRadioButton getRdbtnPerlRegExpr() {
        return rdbtnPerlRegExpr;
    }

    public static JRadioButton getRdbtnXmlTextNodes() {
        return rdbtnXmlTextNodes;
    }

    public JRadioButton getRdbtndoc() {
        return this.rdbtndoc;
    }

    public JRadioButton getRdbtnRichTextFormat() {
        return this.rdbtnRichTextFormat;
    }

    public JRadioButton getRdbtnHtmlPage() {
        return this.rdbtnHtmlPage;
    }

    public JRadioButton getRdbtnPdfDocument() {
        return this.rdbtnPdfDocument;
    }

    public static JList getListFFormats() {
        return listFFormats;
    }

    public static JComboBox getComboPerl() {
        return comboPerl;
    }

    public static JComboBox getComboXml() {
        return comboXml;
    }
}

